# Anthropic API Custom Proxy Example

Simple Python project demonstrating how to use the Anthropic API through a custom proxy endpoint.

## Setup

1. Install dependencies with uv:
```bash
uv sync
```

If you don't have uv installed, install it first:
```bash
curl -LsSf https://astral.sh/uv/install.sh | sh
```

2. Create your config file:
```bash
cp config.yaml.example config.yaml
```

3. Edit `config.yaml` and add your API key:
```yaml
api_key: your_actual_api_key_here
base_url: https://ai.cyberrange.rit.edu
```

## Usage

Run the example script:
```bash
uv run main.py
```

## Configuration

All configuration is in `config.yaml`:
- `api_key`: Your Anthropic API key
- `base_url`: The custom proxy endpoint (default: https://ai.cyberrange.rit.edu)

## Model

The example uses the `claude-sonnet-4-5-20250929` model. You can change this in `main.py` to use a different Claude model if available through your proxy.
